#version 130
#extension GL_ARB_gpu_shader5 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Rounded Box - intersection (Fix)Mod01.fsh  by   xjorma
//https://www.shadertoy.com/view/wsyyWw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Little Modification by David Gallardo / Xjorma 2020   (MIT License)


// The MIT License
// Copyright © 2019 Inigo Quilez
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// Intersection of a ray with a rounded box, testing a single
// corner (sphere) instead of 8, and only 3 edges (cylinders)
// instead of 12. There might be a more compact and efficient
// way to do it, but this is where I landed. However the code
// to compute the surface normal is particularly elegant.
//
// It only works if the corner spheres don't overlap, ie, if
// the raius is smaller than half the size of the base box.

// Other intersectors: https://iquilezles.org/articles/intersectors
//
// Box:             https://www.shadertoy.com/view/ld23DV
// Triangle:        https://www.shadertoy.com/view/MlGcDz
// Capsule:         https://www.shadertoy.com/view/Xt3SzX
// Ellipsoid:       https://www.shadertoy.com/view/MlsSzn
// Sphere:          https://www.shadertoy.com/view/4d2XWV
// Capped Cylinder: https://www.shadertoy.com/view/4lcSRn
// Disk:            https://www.shadertoy.com/view/lsfGDB
// Capped Cone:     https://www.shadertoy.com/view/llcfRf
// Rounded Box:     https://www.shadertoy.com/view/WlSXRW
// Rounded Cone:    https://www.shadertoy.com/view/MlKfzm
// Torus:           https://www.shadertoy.com/view/4sBGDy
// Sphere4:         https://www.shadertoy.com/view/3tj3DW
// Goursat:         https://www.shadertoy.com/view/3lj3DW
// Hexagonal Prism: https://www.shadertoy.com/view/tljBWy


#define AA 2  // reduce this to 1 if you have a slow machine

// intersect capsule : https://iquilezles.org/articles/intersectors
float capIntersect( in vec3 ro, in vec3 rd, in vec3 pa, in vec3 pb, in float r )
{
    vec3  ba = pb - pa;
    vec3  oa = ro - pa;

    float baba = dot(ba,ba);
    float bard = dot(ba,rd);
    float baoa = dot(ba,oa);
    float rdoa = dot(rd,oa);
    float oaoa = dot(oa,oa);

    float a = baba      - bard*bard;
    float b = baba*rdoa - baoa*bard;
    float c = baba*oaoa - baoa*baoa - r*r*baba;
    float h = b*b - a*c;
    if( h>=0.0 )
    {
        float t = (-b-sqrt(h))/a;

        float y = baoa + t*bard;
        
        // body
        if( y>0.0 && y<baba ) return t;

        // caps
        vec3 oc = (y<=0.0) ? oa : ro - pb;
        b = dot(rd,oc);
        c = dot(oc,oc) - r*r;
        h = b*b - c;
        if( h>0.0 )
        {
            return -b - sqrt(h);
        }
    }
    return -1.;
}

// intersect a ray with a rounded box
// https://iquilezles.org/articles/intersectors
// Modified to support bigger radius, probably more optimal solution, but was too lazy nor as good as IQ :(
// I kept the -1 for no collision paradigm even if I hate it (Make the code more complex), but I prefered to stay compatible with IQ interface.
float roundedboxIntersect2( in vec3 ro, in vec3 rd, in vec3 size, in float rad )
{
    
	// bounding box
    vec3 m = 1.0/rd;
    vec3 n = m*ro;
    vec3 k = abs(m)*(size+rad);
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
	float tN = max( max( t1.x, t1.y ), t1.z );
	float tF = min( min( t2.x, t2.y ), t2.z );
	if( tN > tF || tF < 0.0) return -1.0;
    float t = tN;

    // convert to first octant
    vec3 pos = ro+t*rd;
    vec3 s = sign(pos);
    ro  *= s;
    rd  *= s;
    pos *= s;
        
    // faces
    pos -= size;
    pos = max( pos.xyz, pos.yzx );
    if( min(min(pos.x,pos.y),pos.z)<0.0 ) return t;
  
  	// fat edges
    float d;
    d = capIntersect(ro, rd, size * vec3(-1, 1, 1), size, rad);
    t = d > 0. ? d : 1e20;
    d = capIntersect(ro, rd, size * vec3( 1,-1, 1), size, rad);
    t = min(d > 0. ? d : 1e20, t);    
    d = capIntersect(ro, rd, size * vec3( 1, 1,-1), size, rad);
    t = min(d > 0. ? d : 1e20, t);    

    if( t>1e19 ) t=-1.0;
    
	return t;
}



// intersect a ray with a rounded box
// https://iquilezles.org/articles/intersectors
float roundedboxIntersect( in vec3 ro, in vec3 rd, in vec3 size, in float rad )
{
	// bounding box
    vec3 m = 1.0/rd;
    vec3 n = m*ro;
    vec3 k = abs(m)*(size+rad);
    vec3 t1 = -n - k;
    vec3 t2 = -n + k;
	float tN = max( max( t1.x, t1.y ), t1.z );
	float tF = min( min( t2.x, t2.y ), t2.z );
	if( tN > tF || tF < 0.0) return -1.0;
    float t = tN;

    // convert to first octant
    vec3 pos = ro+t*rd;
    vec3 s = sign(pos);
    ro  *= s;
    rd  *= s;
    pos *= s;
        
    // faces
    pos -= size;
    pos = max( pos.xyz, pos.yzx );
    if( min(min(pos.x,pos.y),pos.z)<0.0 ) return t;

    // some precomputation
    vec3 oc = ro - size;
    vec3 dd = rd*rd;
	vec3 oo = oc*oc;
    vec3 od = oc*rd;
    float ra2 = rad*rad;

    t = 1e20;        

    // corner
    {
    float b = od.x + od.y + od.z;
	float c = oo.x + oo.y + oo.z - ra2;
	float h = b*b - c;
	if( h>0.0 ) t = -b-sqrt(h);
    }

    // edge X
    {
	float a = dd.y + dd.z;
	float b = od.y + od.z;
	float c = oo.y + oo.z - ra2;
	float h = b*b - a*c;
	if( h>0.0 )
    {
	  h = (-b-sqrt(h))/a;
      if( h>0.0 && h<t && abs(ro.x+rd.x*h)<size.x ) t = h;
    }
	}
    // edge Y
    {
	float a = dd.z + dd.x;
	float b = od.z + od.x;
	float c = oo.z + oo.x - ra2;
	float h = b*b - a*c;
	if( h>0.0 )
    {
	  h = (-b-sqrt(h))/a;
      if( h>0.0 && h<t && abs(ro.y+rd.y*h)<size.y ) t = h;
    }
	}
    // edge Z
    {
	float a = dd.x + dd.y;
	float b = od.x + od.y;
	float c = oo.x + oo.y - ra2;
	float h = b*b - a*c;
	if( h>0.0 )
    {
	  h = (-b-sqrt(h))/a;
      if( h>0.0 && h<t && abs(ro.z+rd.z*h)<size.z ) t = h;
    }
	}

    if( t>1e19 ) t=-1.0;
    
	return t;
}

// normal of a rounded box
vec3 roundedboxNormal( in vec3 pos, in vec3 siz, in float rad )
{
    return sign(pos)*normalize(max(abs(pos)-siz,0.0));
}


//======================================================




// rotation matrix
mat4 rotate( vec3 v, float angle )
{
    float s = sin( angle );
    float c = cos( angle );
    float ic = 1.0 - c;

    return mat4( v.x*v.x*ic + c,     v.y*v.x*ic - s*v.z, v.z*v.x*ic + s*v.y, 0.0,
                 v.x*v.y*ic + s*v.z, v.y*v.y*ic + c,     v.z*v.y*ic - s*v.x, 0.0,
                 v.x*v.z*ic - s*v.y, v.y*v.z*ic + s*v.x, v.z*v.z*ic + c,     0.0,
			     0.0,                0.0,                0.0,                1.0 );
}

// transform points and vectors
vec3 ptransform( in mat4 mat, in vec3 v ) { return (mat*vec4(v,1.0)).xyz; }
vec3 ntransform( in mat4 mat, in vec3 v ) { return (mat*vec4(v,0.0)).xyz; }

// texture sampling
vec4 boxmap( sampler2D sam, in vec3 p, in vec3 n )
{
    vec3 m = n*n; m=m*m; m=m*m;
	vec4 x = texture2D( sam, p.yz );
	vec4 y = texture2D( sam, p.zx );
	vec4 z = texture2D( sam, p.xy );
	return (x*m.x + y*m.y + z*m.z)/(m.x+m.y+m.z);
}

//======================================================

// putting these in a "box" struct leads to precision problems
// on Android... :(
mat4  box_world_to_obj;
mat4  box_obj_to_world;
vec3  box_size;
float box_radius;
bool  side;

vec2 intersect( in vec3 ro, in vec3 rd )
{
    vec2 res = vec2(1e20,-1.0);
    
    // plane
    {
        float t = (-1.0-ro.y)/rd.y;
        if( t>0.0 ) res = vec2(t,1.0);
    }

    // rounded box
    {
        // convert ray from world to box space
        vec3 rdd = ntransform(box_world_to_obj, rd );
        vec3 roo = ptransform(box_world_to_obj, ro );
        // intersect in box space
        float t;
        if(side)
        {
        	t = roundedboxIntersect(roo,rdd,box_size,box_radius);
        }
        else
        {
        	t = roundedboxIntersect2(roo,rdd,box_size,box_radius);
        }
        if( t>0.0 && t<res.x ) res = vec2(t,2.0);
    }
    
    return res;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // camera movement	
    float an = 0.15*(iTime-10.0);
    vec3 ta = vec3( 0.0, 0.0, 0.0 );
    vec3 ro = ta + vec3( 2.0*cos(an), 0.2, 2.0*sin(an) );
    // camera matrix
    vec3 ww = normalize( ta - ro );
    vec3 uu = normalize( cross(ww,vec3(0.6,8.0,0.0) ) );
    vec3 vv =          ( cross(uu,ww));

    // rounded box animation
    box_obj_to_world = 
                       rotate( normalize(vec3(1.0,1.0,0.1)), iTime ); 
    box_world_to_obj = inverse( box_obj_to_world );
    box_size = vec3((-cos(iTime) + 1.) * 0.5) * 0.75;
    box_radius = (cos(iTime) + 1.) * 0.5 *.75;
    side = fragCoord.x < iMouse.x;

    // render
    vec3 tot = vec3(0.0);
    
    #if AA>1
    for( int m=0; m<AA; m++ )
    for( int n=0; n<AA; n++ )
    {
        // pixel coordinates
        vec2 o = vec2(float(m),float(n)) / float(AA) - 0.5;
        vec2 p = (2.0*(fragCoord+o)-iResolution.xy)/iResolution.y;
        #else    
        vec2 p = (2.0*fragCoord-iResolution.xy)/iResolution.y;
        #endif
    
	    // create view ray
        vec3 rd = normalize( p.x*uu + p.y*vv + 1.6*ww );

        // sky
        vec3 col = vec3(0.6,0.75,0.85) - 0.97*rd.y;

        // raymarch geometry
        vec2 tm = intersect( ro, rd );
        if( tm.y>0.0 )
        {
            // shading
            vec3 pos = ro + tm.x*rd;
            vec3 nor;
            vec3 mate;
            
            if( tm.y<1.5 ) // floor
            {
                nor = vec3(0.0,1.0,0.0);
                mate = 0.35*texture2D( texture0, 0.2*pos.xz ).xyz;
            }
            else // rounded box
            {
                // convert position from world to box space
                vec3 bpos = ptransform(box_world_to_obj,pos);
                // compute normal in box space
                vec3 bnor = roundedboxNormal(bpos,box_size,box_radius);
                // convert normal from box to world space
                nor = ntransform(box_obj_to_world,bnor);
                // sample texture
                mate = 0.35*boxmap( texture0, bpos, bnor ).xyz;
            }
            
            // lighting
            vec3  lig = normalize(vec3(0.8,0.4,-0.6));
            float dif = clamp( dot(nor,lig), 0.0, 1.0 );
            vec3  hal = normalize(lig-rd);
            float sha = step( intersect( pos+0.01*nor, lig ).y, 0.0 );
            float amb = 0.6 + 0.4*nor.y;
            float bou = clamp(0.3-0.7*nor.y,0.0,1.0);
            float spe = clamp(dot(nor,hal),0.0,1.0);
            col  = 4.0*vec3(1.00,0.80,0.60)*dif*sha;
            col += 2.0*vec3(0.20,0.30,0.40)*amb;
            col += 2.0*vec3(0.30,0.20,0.10)*bou;
			col *= mate;            
            col += 0.3*pow(spe,8.0)*dif*sha*(0.04+0.96*pow(clamp(dot(lig,hal),0.0,1.0),5.0));
            col = mix( col, vec3(0.6,0.7,0.8), 1.0-exp(-0.001*tm.x*tm.x) );           
        }
        
        // vignetting        
        col *= 1.0 - 0.1*dot(p,p);

	    tot += col;
    #if AA>1
    }
    tot /= float(AA*AA);
    #endif

    // gamma
    tot = pow( tot, vec3(0.45) );
    
	// grading
    tot = clamp(tot,0.0,1.0);
    tot = tot*tot*(3.0-2.0*tot);
    
    tot = mix(tot, vec3(1,0,0),max(0.,1. - abs(iMouse.x - fragCoord.x) / 2.));

    fragColor = vec4( tot, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

